
/////////////////////////////////////////////////////////
// general parameters

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;
float4x4	shader_light_view;
float4x4	shader_light_viewProj;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//material

float4		shader_material_diffuse;
float4		shader_material_ambient;
float4		shader_material_specular;
float		shader_material_eccentricity;
float		shader_material_transparency;
float		shader_material_reflectivity;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

/////////////////////////////////////////////////////////
// unique parameters

#define		SHADOW_EPSILON 0.001f
float		shader_misc_shadow_mapSize;
float		shader_misc_shadow_mapTexelSize;
float4x4	g_shadowerTransform;
float4x4	g_textureMatrix;
float		g_light_farPlane;

////////////////////////////////////////////////////////////////////
// structures

struct VS_INPUT
{
	float4 position		: POSITION;
	float3 normal		: NORMAL;
	float4 colour		: COLOR;
	float2 tex0			: TEXCOORD0;
};

struct VS_OUTPUT_HIGH
{
	float4 position		: POSITION;
	float4 posTex		: TEXCOORD0;
	float depth			: TEXCOORD1;
};

////////////////////////////////////////////////////////////////////
// functions

VS_OUTPUT_HIGH vs_lighting_env_high( VS_INPUT input )
{
	VS_OUTPUT_HIGH output = (VS_OUTPUT_HIGH) 0;

	output.position = mul(input.position, shader_transform_world);
	output.posTex = mul( output.position, shader_light_viewProj );
	output.position = mul(output.position, shader_transform_viewProj);

	output.depth = saturate(output.posTex.z);
  	
	return output;
}

sampler sample_colour_shadow = sampler_state 
{ 
	Texture = (shader_texture_shadowmap); 
	AddressU = Clamp; 
	AddressV = Clamp; 
};

float4 ps_lighting_env_high( VS_OUTPUT_HIGH input ) : COLOR0
{
	float2 projTexCoords;
	projTexCoords.x = input.posTex.x / 2.0f + 0.5f;
	projTexCoords.y = -input.posTex.y / 2.0f + 0.5f;
	
	float shadowTerm = ((tex2D( sample_colour_shadow, projTexCoords ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)
	 + (tex2D( sample_colour_shadow, projTexCoords + float2( -shader_misc_shadow_mapTexelSize, 0.0f ) ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)
	 + (tex2D( sample_colour_shadow, projTexCoords + float2( shader_misc_shadow_mapTexelSize, 0.0f ) ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)
	 + (tex2D( sample_colour_shadow, projTexCoords + float2( 0.0f, -shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)
	 + (tex2D( sample_colour_shadow, projTexCoords + float2( 0.0f, shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)
	 + (tex2D( sample_colour_shadow, projTexCoords + float2( -shader_misc_shadow_mapTexelSize, -shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)
	 + (tex2D( sample_colour_shadow, projTexCoords + float2( shader_misc_shadow_mapTexelSize, -shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)
	 + (tex2D( sample_colour_shadow, projTexCoords + float2( -shader_misc_shadow_mapTexelSize, shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)
	 + (tex2D( sample_colour_shadow, projTexCoords + float2( shader_misc_shadow_mapTexelSize, shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)) / 9.0f;
	
	return float4(0,0,0,(1.0-shader_light_ambient.r) * (1.0-shadowTerm) * 0.75);
}

////////////////////////////////////////////////////////////

technique tech_lighting_env_high_11_20
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_lighting_env_high();	
		PixelShader = compile ps_2_0 ps_lighting_env_high();	
	}
}

technique tech_lighting_env_high_11_00
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_lighting_env_high();
	}
}